" Unit 3 - Lecture 6 "
"------------------------------------------------------------------------"

" Bootstraping "
"
- What is Bootstraping?
- Why do we require the same?

"
"------------------------------------------------------------------------"

" Non- Parametric "

" Example "
"
Suppose we have the following sample of 10 
values from an Exponential distribution
with unknown parameter lambda.

0.61, 6.47, 2.56, 5.44, 2.72,
0.87, 2.77, 6.00, 0.14, 0.75

Write the R code to obtain 1,000
bootstrap estimates and 
display its distribution.

Find 95% CI of lambda.

"

X = c(0.61, 6.47, 2.56, 5.44, 2.72,
      0.87, 2.77, 6.00, 0.14, 0.75)

lambda = c()

set.seed(1)

for(i in 1:1000){
  
  DUMMY = sample(X,replace = T)
  lambda[i] = 1 / mean(DUMMY)

}

hist(lambda)

quantile(lambda,
         probs = c(0.025,0.975))


"------------------------------------------------------------------------"

" Parametric "
"
Assume that the sample is considered 
to come from a given distribution.

Find the empirical sampling distribution 
of lambda_hat.

Use the sample information given above.

"


X = c(0.61, 6.47, 2.56, 5.44, 2.72,
      0.87, 2.77, 6.00, 0.14, 0.75)

lambda = c()

set.seed(1)

for(i in 1:1000){
  
  DUMMY = rexp(length(X),1 / mean(X))
  lambda[i] = 1 / mean(DUMMY)
  
}

hist(lambda)

quantile(lambda,
         probs = c(0.025,0.975))



"------------------------------------------------------------------------"

"
Exam Questions:

"

"
Q1.)
In a very small empirical study a 
sample from a random variable X is observed. 

The data can be entered into R 
using the following code:

x = c(0.22,0.38,1.28,0.54,
      0.56,1.36,0.55,0.37,
      0.43,0.46,0.62,0.54,
      0.54,0.51,0.44,0.68,
      0.55,0.30)

Construct a 95% confidence interval for 
the expected value of X using the bootstrap
method with 10,000 bootstrap replications using
a seed of 6171.

"

x = c(0.22,0.38,1.28,0.54,
      0.56,1.36,0.55,0.37,
      0.43,0.46,0.62,0.54,
      0.54,0.51,0.44,0.68,
      0.55,0.30)

Mu = c()

set.seed(6171)

for(i in 1:10000){
  
  DUMMY = sample(x,replace = T)
  Mu[i] = mean(DUMMY)

}

quantile(Mu,c(0.025,0.975))

"------------------------------------------------------------------------"

" 
Q2.)
The following data represent the average 
total number of marks obtained for a
particular exam, observed over seven exam
sessions that had been administered by a
professional examination body:

87, 53, 72, 90, 78, 85, 83

Investigate whether the Poisson model is 
appropriate for these data, by calculating
the sample mean and sample variance 
of 5 Poisson samples having the same 
size and mean as the sample given above.

"


"------------------------------------------------------------------------"

"
Understand:
- Weightage of Unit 4
  - Regression: Linear Regression & GLM
  - ANOVA
  - PCA

- Regression Analysis
- Examples
- Why?
- When?
- SLR, MLR
- Line Of Best Fit
- OLS
- Assumptions

"

"------------------------------------------------------------------------"
